
/****** Object:  UserDefinedFunction [dbo].[UFD_PDV_VD_RC_CLI]    Script Date: 03/05/2012 17:28:47 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/****************************************************************************************************************
										M E L H O R E S  C L I E N T E S
*****************************************************************************************************************/


-- SELECT  * FROM UFD_PDV_VD_RC_CLI (1,'1,2,3,4,5,6,7,8,9,10','20090901','20090930',15 ,200 ,1)


ALTER  FUNCTION [dbo].[UFD_PDV_VD_RC_CLI] ( @CD_EMP			INT,
											 @FILIAL 		VARCHAR(500),
											 @DT_INI		DATETIME,
											 @DT_FIM		DATETIME,	
											 @FREQ			INT	,
											 @VLR_MIN		MONEY,
											 @LINHA			VARCHAR(500))
 

RETURNS		@RS_TEMP		TABLE (	CD_FILIAL			INT,
									CD_CLI				INT,
									NR_CARTAO			VARCHAR(50),
									NM_CLIENTE			VARCHAR(500),
									RZ_CLI				VARCHAR(500),
									END_CLI				VARCHAR(500),
									BAIRRO				VARCHAR(200),
									TELEFONE01			VARCHAR(50),
									TELEFONE02			VARCHAR(50),
									TELEFONE03			VARCHAR(50),
									TELEFONE04			VARCHAR(50),
									DT_ULT_COMPRA		DATETIME,
									CD_PROD				INT,
									DS_PROD				NVARCHAR(250),
									CD_LINHA			INT,
									DS_LINHA			NVARCHAR(250),
									FORMA_PGTO			NVARCHAR(50),
									VLR_VD				MONEY,
									VLR_LIQ_VD			MONEY,
									ITENS				MONEY,
									FREQ				MONEY,
									CD_MEDICO_REC       INT,
									NM_MEDICO           NVARCHAR(250))

AS
BEGIN



/****************************************************************************************************************
										T A B E L A S   A U X I L I A R E S
*****************************************************************************************************************/

	DECLARE @RS_FREQ AS TABLE(	CD_EMP			INT,
								CD_CLI			INT,
								FREQ			MONEY)

	DECLARE @RS_CLI AS TABLE(	CD_EMP				INT,
								CD_CLI				INT,
								NR_CARTAO			VARCHAR(50),
								NM_CLI				VARCHAR(500),
								RZ_CLI				VARCHAR(500),
								END_CLI				VARCHAR(500),
								BAIRRO				VARCHAR(100),
								TELEFONE01			VARCHAR(50),
								TELEFONE02			VARCHAR(50),
								TELEFONE03			VARCHAR(50),
								TELEFONE04			VARCHAR(50),
								DT_ULT_CP			DATETIME)	
	
	DECLARE @RS_VD AS TABLE(	CD_EMP				INT,	
								CD_FILIAL			INT,	
								CD_CLI				INT,
								CD_PROD				INT,
								DS_PROD				VARCHAR(250),
								CD_LINHA			INT,
								DS_LINHA			VARCHAR(250),								
								FORMA_PGTO			VARCHAR(50),
								VLR_VD				MONEY,
								VLR_LIQ_VD			MONEY,
								ITENS				MONEY,
								CD_MEDICO_REC       INT,
								NM_MEDICO           VARCHAR(250))


/****************************************************************************************************************
								F R E Q U  N C I A   D E   C O M P R A
*****************************************************************************************************************/

	INSERT INTO @RS_FREQ
	SELECT 
		V.CD_EMP,
		V.CD_CLI, 
		COUNT(DISTINCT DT_VD) QTD	
	FROM 
		V_PDV_VD_IT V
		INNER JOIN (SELECT 
							CD_EMP,
							CD_CLI,
							SUM(TOT_IT) TOT							
						FROM 
							V_PDV_VD_IT V
						WHERE 
							V.DT_VD BETWEEN @DT_INI AND @DT_FIM
							AND V.CD_EMP = @CD_EMP
							AND V.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@FILIAL))
						GROUP BY 
							CD_EMP , CD_CLI	
						HAVING
							SUM(TOT_IT) >= @VLR_MIN

						) M ON
		V.CD_CLI = M.CD_CLI AND 
		V.CD_EMP  = M.CD_EMP 

	WHERE
		V.CD_CLI NOT IN (SELECT CD_CLI FROM  RC_CLI WHERE CONS_FINAL =1)
		AND V.DT_VD BETWEEN @DT_INI AND @DT_FIM
		AND V.CD_EMP = @CD_EMP
		AND V.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@FILIAL))		
	GROUP BY
		V.CD_EMP,
		V.CD_CLI
	HAVING 
		COUNT(DISTINCT DT_VD) +0 >= @FREQ
	 

/****************************************************************************************************************
									D A D O S  D O  C L I E N T E
*****************************************************************************************************************/

	INSERT INTO @RS_CLI
	SELECT DISTINCT
		C.CD_EMP,
		C.CD_CLI,
		M.NR_CARTAO,
		C.NM_FANT,
		C.RZ_CLI,
		C.END_CLI,
		C.BAIRRO,
		C.TEL TELEFONE01,
		C.TELEFONE1 TELEFONE02,
		C.TELEFONE2 TELEFONE03,
		C.TELEFONE3 TELEFONE04,	
		'19000101'
	FROM

		RC_CLI C
		INNER JOIN @RS_FREQ F ON 
		C.CD_CLI = F.CD_CLI AND
		C.CD_EMP = F.CD_EMP
		LEFT JOIN RC_CLI_FIDELI_CARTAO M ON
		C.CD_EMP = M.CD_EMP AND 
		C.CD_CLI = M.CD_CLI
	WHERE
		C.CD_EMP = @CD_EMP




	UPDATE 
		C 
	SET 
		DT_ULT_CP = V.DT
	FROM 
		@RS_CLI C
		INNER JOIN (SELECT	
							CD_EMP, 
							CD_CLI, 
							MAX(DT_VD) DT 
						FROM 
							PDV_VD V							
						WHERE
							V.CD_EMP=@CD_EMP 
							AND V.ST_VD=0
							AND V.DT_VD BETWEEN @DT_INI AND @DT_FIM
							AND V.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@FILIAL))
						GROUP BY 
							CD_EMP,
							CD_CLI
					) V ON
		C.CD_CLI = V.CD_CLI AND
		C.CD_EMP  = V.CD_EMP 

/****************************************************************************************************************
												V E N D A S
*****************************************************************************************************************/

	INSERT INTO @RS_VD
	SELECT
		V.CD_EMP,
		V.CD_FILIAL,
		V.CD_CLI,
		A.CD_PROD,
		A.DS_PROD,
		A.CD_ARV_MERC_LINHA,
		A.DS_ARV_MERC_LINHA,

		CASE WHEN  V.VLR_DINH  > V.VLR_CHQS AND   V.VLR_DINH  >  V.VLR_CARTAO   AND V.VLR_DINH  >  V.VLR_TICKETS    AND V.VLR_DINH  >  V.VLR_DUP  AND  V.VLR_DINH  >   V.VLR_CONV THEN
				'DINHEIRO'
			WHEN   V.VLR_CHQS >  V.VLR_DINH  AND  V.VLR_CHQS >  V.VLR_CARTAO   AND V.VLR_CHQS  >  V.VLR_TICKETS    AND V.VLR_CHQS  >  V.VLR_DUP  AND  V.VLR_CHQS  >   V.VLR_CONV THEN
				'CHEQUE'
			WHEN  V.VLR_CARTAO > V.VLR_CHQS  AND  V.VLR_CARTAO > V.VLR_DINH   AND V.VLR_CARTAO >  V.VLR_TICKETS    AND  V.VLR_CARTAO >  V.VLR_DUP  AND  V.VLR_CARTAO >   V.VLR_CONV THEN
				'CARTAO'
			WHEN  V.VLR_TICKETS  > V.VLR_CHQS AND   V.VLR_TICKETS  >  V.VLR_CARTAO   AND V.VLR_TICKETS  >  V.VLR_DINH AND V.VLR_TICKETS  >  V.VLR_DUP  AND V.VLR_TICKETS  >  V.VLR_CONV THEN
				'TICKET'
			WHEN  V.VLR_DUP  > V.VLR_CHQS AND   V.VLR_DUP  >  V.VLR_CARTAO   AND V.VLR_DUP  >  V.VLR_TICKETS    AND V.VLR_DUP  >  V.VLR_DINH  AND  V.VLR_DUP  >   V.VLR_CONV THEN
				'DUPLICATA'
			WHEN  V.VLR_CONV  > V.VLR_CHQS AND   V.VLR_CONV  >  V.VLR_CARTAO   AND V.VLR_CONV  >  V.VLR_TICKETS    AND V.VLR_CONV  >  V.VLR_DUP  AND  V.VLR_CONV  >   V.VLR_DINH THEN
				'CONVENIO'
			ELSE
				'NAO DEFINIDO'

		END AS FORMA_PGTO,

		SUM	(V.TOT_IT_BRUTO) VLR_VD,
		SUM	(V.TOT_IT) VLR_VD_LIQ,
		SUM	(V.QT_IT) ITENS,
		R.CD_MEDICO_REC,
		M.NM_MEDICO
		
	FROM
		V_PDV_VD_IT V
		INNER JOIN V_EST_PROD_ARV_MERCADOLOGICA A ON
		V.CD_EMP = A.CD_EMP AND
		V.CD_PROD = A.CD_PROD
 		
		INNER JOIN @RS_FREQ F ON 
		V.CD_CLI = F.CD_CLI AND 
		V.CD_EMP = F.CD_EMP 
		
		LEFT JOIN PDV_VD_IT_REC R ON 
 		R.CD_EMP    = V.CD_EMP AND
 		R.CD_FILIAL = V.CD_FILIAL AND
 		R.CD_VD = V.CD_VD  AND
		R.CD_IT = V.CD_IT
		
        LEFT JOIN GLB_MEDICOS M ON 
    	R.CD_EMP = M.CD_EMP AND
    	R.CD_MEDICO_REC = M.CD_CTR

	WHERE
		V.DT_VD BETWEEN @DT_INI AND @DT_FIM
		AND V.CD_EMP = @CD_EMP
		AND V.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@FILIAL))
		AND A.CD_ARV_MERC_LINHA IN (SELECT ID FROM UFD_PRM_IN_STRING(@LINHA))
	GROUP BY
		V.CD_EMP,
		V.CD_FILIAL,
		V.CD_CLI,
		V.CD_VD,
		A.CD_PROD,
		A.DS_PROD,
		A.CD_ARV_MERC_LINHA,
		A.DS_ARV_MERC_LINHA,
		V.VLR_CONV,
		V.VLR_CHQS ,
		V.VLR_CARTAO,
		V.VLR_TICKETS,
		V.VLR_DUP,
		V.VLR_DINH,
		R.CD_MEDICO_REC,
		M.NM_MEDICO
			

/****************************************************************************************************************
												R E T O R N O
*****************************************************************************************************************/
	INSERT INTO @RS_TEMP		
	SELECT
		V.CD_FILIAL,
		V.CD_CLI,
		C.NR_CARTAO,
		C.NM_CLI,
		C.RZ_CLI,
		C.END_CLI,
		C.BAIRRO,
		C.TELEFONE01,
		C.TELEFONE02,
		C.TELEFONE03,
		C.TELEFONE04,
		C.DT_ULT_CP,
		V.CD_PROD,
		V.DS_PROD,
		V.CD_LINHA,
		V.DS_LINHA,
		V.FORMA_PGTO,
		V.VLR_VD,
		V.VLR_LIQ_VD,
		V.ITENS,
		F.FREQ,
		V.CD_MEDICO_REC,
		V.NM_MEDICO
	FROM
		@RS_VD V
		INNER JOIN @RS_CLI C ON
		V.CD_CLI = C.CD_CLI	AND 
		V.CD_EMP  = C.CD_EMP 
		INNER JOIN @RS_FREQ F ON 
		V.CD_CLI = F.CD_CLI AND 
		V.CD_EMP  = F.CD_EMP  




/****************************************************************************************************************
												F    I    M 
*****************************************************************************************************************/

	RETURN
END


GO


